<%@ Control Language="c#" AutoEventWireup="false" Codebehind="TasksList.ascx.cs" Inherits="Mediachase.UI.Web.Tasks.Modules.TasksList" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="BlockHeader" src="..\..\Modules\BlockHeader.ascx"%>
<%@ Register TagPrefix="ibn" TagName="DTCC" src="..\..\Modules\DateTimeClientControl.ascx" %>
<%@ register TagPrefix="dg" namespace="Mediachase.UI.Web.Modules.DGExtension" Assembly="Mediachase.UI.Web" %>
<script lang="javascript">
	function ChangeModify()
	{
		document.forms[0].<%=btnApplyFilter.ClientID%>.disabled = true;
		<%= Page.GetPostBackClientEvent(btnPostBackPeriod, "")%>
	}
	
	function ChangePeriod()
	{
		document.forms[0].<%=btnApplyFilter.ClientID%>.disabled = true;
		<%= Page.GetPostBackClientEvent(btnPostBackStatus, "")%>
	}
	
	function DeleteItem(ItemId,IsToDo)
	{
		if(IsToDo == 1)
			DeleteToDo(ItemId);
		else
			DeleteTask(ItemId);
	}

	function DeleteToDo(ToDoId)
	{
		document.forms[0].<%=hdnToDoId.ClientID %>.value = ToDoId;
		var DeleteType = FCKShowDialog("../ToDo/DeleteToDoModal.aspx", window, 420, 240);
		if (DeleteType == 'ToDo')
			<%=Page.GetPostBackClientEvent(lbDeleteToDo,"") %>
		if (DeleteType == 'All')
			<%=Page.GetPostBackClientEvent(lbDeleteToDoAll,"") %>
		if (DeleteType == 'Catch')
		{
			if(confirm('<%=LocRM.GetString("tWarningTodo")%>'))
				<%=Page.GetPostBackClientEvent(lbDeleteToDo,"") %>
		}
	}
	
	function DeleteTask(TaskId)
	{
		document.forms[0].<%=hdnTaskId.ClientID %>.value = TaskId;
		var DeleteType = FCKShowDialog("../Tasks/DeleteTaskModal.aspx", window, 420, 240);
		if (DeleteType == 'Task')
			<%=Page.GetPostBackClientEvent(lbDeleteTask,"") %>
		if (DeleteType == 'All')
			<%=Page.GetPostBackClientEvent(lbDeleteTaskAll,"") %>
		if (DeleteType == 'Catch')
		{
			if(confirm('<%=LocRM.GetString("tWarningTask")%>'))
				<%=Page.GetPostBackClientEvent(lbDeleteTask,"") %>
		}
	}

	function FCKShowDialog(pagePath, args, width, height)
	{
		if(browseris.ie5up)
		{
			return showModalDialog(pagePath, args, "dialogWidth:" + width + "px;dialogHeight:" + height + "px;help:no;scroll:auto;status:no");
		}
		else
		{
			return 'Catch';
		}
	}
</script>
<TABLE class="ibn-propertysheet ibn-stylebox" style="MARGIN-TOP:0px" cellSpacing="0" cellPadding="0" width="100%" border="0">
	<tr>
		<td><ibn:blockheader id="secHeader" title="" runat="server"></ibn:blockheader></td>
	</tr>
	<tr>
		<td>
			<table runat=server id="tblFilter" class="ibn-alternating ibn-navline" border="0" cellSpacing="0" cellPadding="3" width="100%">
				<tr height="40px" style="display:none">
					<td width="10px"></td>
					<td>
						<table cellpadding="2" cellspacing="0" border="0">
							<tr>
								<td class="text" width="215" align=left>
									<select id="ddStatus" onchange="ChangePeriod();" class="text" style="Width: 214px" Runat="server" NAME="ddStatus"></select>
								</td>
								<td align=left></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr height="50px">
					<td width="10px"></td>
					<td>
						<table runat=server id="periodTable" cellpadding="2" cellspacing="0" border="0">
							<tr>
								<TD width="60px" class="text"><%=LocRM.GetString("tPeriod")%>:&nbsp;</TD>
								<TD vAlign="center">
									<SELECT class="text" id="ddPeriod" style="WIDTH: 150px" onchange="ChangeModify();" runat="server" NAME="ddPeriod"></SELECT>
								</TD>
								<TD>
									<TABLE id="tableDate" border="0" cellSpacing="2" cellPadding="0" runat="server">
										<TR>
											<TD class="text" style="padding-left:10px">&nbsp;<%=LocRM.GetString("tFrom")%>:&nbsp;</TD>
											<TD style="padding-left:10px"><ibn:DTCC id="dtcStartDate" Path_Img="../Layouts/Images/" Path_JS="../Scripts/" File_JS="mcCalendScript.js" strTextBoxWidth="90px" SelectionDateType="Day" ViewStartDate="True" RequiredField="True" runat="server"></ibn:DTCC></td>
											<TD class="text" style="padding-left:10px"><%=LocRM.GetString("tTo")%>:&nbsp;</TD>
											<TD style="padding-left:10px"><ibn:DTCC id="dtcEndDate" Path_Img="../Layouts/Images/" Path_JS="../Scripts/" File_JS="mcCalendScript.js" strTextBoxWidth="90px" SelectionDateType="Day" ViewStartDate="True" RequiredField="True" runat="server"></ibn:DTCC></td>
											<td align=right width="90px" style="padding-left:20px"><asp:button id="btnApplyFilter" CssClass="text" Runat="server"></asp:button>&nbsp;&nbsp;</td>
											<td><asp:Label ID="lblCompareError" CssClass="ibn-alerttext" Runat=server Visible=False></asp:Label></td>
										</TR>
									</TABLE>
								</TD>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td class="ibn-propertysheet" valign="top">
			<dg:datagridextended id="dgActivities" runat="server" allowpaging="True" pagesize="10" allowsorting="True" cellpadding="1" gridlines="None" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%">
				<Columns>
					<asp:TemplateColumn SortExpression="Title">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%#
							Mediachase.UI.Web.Util.CommonHelper.GetTaskToDoLink 
							(
								(int)DataBinder.Eval(Container.DataItem, "ItemId"),
								(int)DataBinder.Eval(Container.DataItem, "IsToDo"),
								DataBinder.Eval(Container.DataItem, "Title").ToString(),
								(int)DataBinder.Eval(Container.DataItem, "StateId")
							)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn  SortExpression="ProjectTitle">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# GetProjectLink( 
								(int)DataBinder.Eval(Container.DataItem, "ProjectId"),
								DataBinder.Eval(Container.DataItem, "ProjectTitle").ToString()
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2" Width="150px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="150px"></ItemStyle>
						<ItemTemplate>
							<%# GetLink( 
								(int)DataBinder.Eval(Container.DataItem, "ManagerId")
							)%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="IsToDo" HeaderText="">
						<HeaderStyle CssClass="ibn-vh2" Width="70px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="70px"></ItemStyle>
						<ItemTemplate>
							<%# GetTypeString((int)DataBinder.Eval(Container.DataItem,"IsToDo"))%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="StartDate">
						<HeaderStyle CssClass="ibn-vh2" Width="95px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="95px"></ItemStyle>
						<ItemTemplate>
						<span runat="server"  Visible='<%#(bool)DataBinder.Eval(Container.DataItem,"ShowStartDate")%>' ID="Span3">
							<%# ((DateTime)DataBinder.Eval(Container.DataItem,"StartDate")).ToShortDateString()%></span>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="FinishDate">
						<HeaderStyle CssClass="ibn-vh2" Width="80px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="80px"></ItemStyle>
						<ItemTemplate>
						<span runat="server" Visible='<%#(bool)DataBinder.Eval(Container.DataItem,"ShowFinishDate")%>' ID="Span4">
							<%# ((DateTime)DataBinder.Eval(Container.DataItem,"FinishDate")).ToShortDateString()%></span>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:templatecolumn itemstyle-width="60" Visible="True">
						<headerstyle horizontalalign="Right" cssclass="ibn-vh-right" width="60px"></headerstyle>
						<itemstyle horizontalalign="Right" cssclass="ibn-vb2" width="60px"></itemstyle>
						<itemtemplate>
							<asp:HyperLink Visible='<%# GetBool((int)DataBinder.Eval(Container.DataItem, "CanEdit")) %>' 
								ImageUrl = "../../layouts/images/Edit.GIF" 
								NavigateUrl='<%# GetEditLink((int)DataBinder.Eval(Container.DataItem, "ItemId"),(int)DataBinder.Eval(Container.DataItem, "IsToDo")) %>' 
								Runat="server" ToolTip='<%#LocRM.GetString("Edit") %>' ID="Hyperlink1" NAME="Hyperlink1">
								</asp:HyperLink>
							&nbsp;&nbsp;
							<asp:HyperLink id="ibDelete" runat="server" 
								imageurl="../../layouts/images/DELETE.GIF" 
								Visible='<%# GetBool((int)DataBinder.Eval(Container.DataItem, "CanDelete")) %>' 
								NavigateUrl='<%# "javascript:DeleteItem(" + DataBinder.Eval(Container.DataItem, "ItemId").ToString() + "," + DataBinder.Eval(Container.DataItem, "IsToDo").ToString() + ")" %>' >
							</asp:HyperLink>
						</itemtemplate>
					</asp:templatecolumn>
				</Columns>
			</dg:datagridextended>
		</td>
	</tr>
</table>
<table cellpadding=0 cellspacing=0 border=0><tr height="10px"><td></td></tr></table>
<asp:Button ID="btnPostBackStatus" Runat=server Visible=False CausesValidation=False></asp:Button>
<asp:Button ID="btnPostBackPeriod" Runat=server Visible=False CausesValidation=False></asp:Button>
<asp:LinkButton id="lbDeleteTask" runat="server" Visible="False"></asp:LinkButton>
<asp:LinkButton id="lbDeleteTaskAll" runat="server" Visible="False"></asp:LinkButton>
<asp:LinkButton id="lbDeleteToDo" runat="server" Visible="False"></asp:LinkButton>
<asp:LinkButton id="lbDeleteToDoAll" runat="server" Visible="False"></asp:LinkButton>
<INPUT id="hdnToDoId" type="hidden" name="hdnToDoId" runat="server">
<INPUT id="hdnTaskId" type="hidden" name="hdnTaskId" runat="server">